<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    * 
    * Classe che definisce l'oggetto documento di Geecom Doc
    */

    class Documento {
        private $db;
        private $id;
        private $cartella;
        private $utente;
        private $nome;
        private $descrizione;
        private $percorso;
        private $dataCreazione;
        
        function __construct($db, $id, $cartella = 0, $utente = 0, $nome = "", $descrizione = "", $percorso = "", $dataCreazione = "") {
            $this->db = $db;
            $this->id = $id;
            $this->cartella      = $cartella;
            $this->utente        = $utente;
            $this->nome          = $nome;
            $this->descrizione   = $descrizione;
            $this->percorso      = $percorso;
            $this->dataCreazione = $descrizione;
        }
        
        function crea() {
            $dataCreazione = date("Y-m-d");
            
            $query = "INSERT INTO geecD_documenti VALUES(NULL,'$this->cartella','$this->utente','$this->nome','$this->descrizione','$this->percorso','$dataCreazione')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }

        function modifica() {
            $query = "UPDATE geecD_documenti SET cartella='$this->cartella', utente='$this->utente', nome='$this->nome', descrizione = '$this->descrizione' WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function rinomina() {
            $query = "UPDATE geecD_documenti SET nome='$this->nome' WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function sposta($idCartella) {
            $query = "UPDATE geecD_documenti SET cartella='$idCartella' WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecD_documenti",$this->id);
            $this->db->eseguiQueryCancellazione("geecD_versioniDocumento",$this->id,"idDocumento");
        }

        function eliminaMessaggiChat() {
            $query = "DELETE FROM geecD_messaggiChat WHERE idDocumento = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function eliminaVersione($idVersione) {
            $this->db->eseguiQueryCancellazione("geecD_versioniDocumento",$idVersione);
        }
        
        function caricaDatiDalDatabase() {
            $datiDocumento = $this->db->leggiSingolaRiga("geecD_documenti",$this->id);
            $this->datiDocumento = $datiDocumento;
            $this->cartella      = $datiDocumento["cartella"];
            $this->utente        = $datiDocumento["utente"];
            $this->nome          = $datiDocumento["nome"];
            $this->descrizione   = $datiDocumento["descrizione"];
            $this->percorso      = $datiDocumento["percorso"];
        }
        
        function aggiungiVersione($autore,$percorsoFile,$dimensione) {
            $data  = date("Y-m-d H:i:s");
            $query = "INSERT INTO `geecD_versioniDocumento` (`id`, `idDocumento`, `autore`, `descrizione`, `percorsoFile`, `numeroDownload`, `dimensione`, `dataCreazione`) 
                        VALUES (NULL, '$this->id', '$autore','$this->descrizione', '$percorsoFile', '0', '$dimensione', '$data')";
            return $this->db->eseguiQueryCreazione($query);
        }
        
        function stampaBreadcrumbDocumento() {
            ?>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <?php 
                        if($this->datiDocumento["cartella"]>0) {
                            $arraySottoCartelle = array();
                            $datiSottoCartella  = $this->db->leggiSingolaRiga("geecD_cartelle",$this->datiDocumento["cartella"]);
                            while($datiSottoCartella != null) {
                                $arraySottoCartelle[count($arraySottoCartelle)] = "<li class=\"breadcrumb-item\"><a href=\"dettagliCartella.php?id={$datiSottoCartella["id"]}\">{$datiSottoCartella["nome"]}</a></li>";
                                if($datiSottoCartella["cartellaMadre"]!=0) {
                                    $datiSottoCartella  = $this->db->leggiSingolaRiga("geecD_cartelle",$datiSottoCartella["cartellaMadre"]);
                                }
                                else {
                                    $datiSottoCartella = null;
                                }
                            }
                            
                            $arraySottoCartelle = array_reverse($arraySottoCartelle);
                            foreach($arraySottoCartelle as $sottoCartella) {
                                echo $sottoCartella;
                            }
                        }
                        else { // sta visualizzando la cartella radice
                            ?>
                            <li class="breadcrumb-item"><a href="dettagliCartella.php?id=1">Cartella radice</a></li>
                            <?php
                        }
                        ?>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->datiDocumento["nome"] ?></li>
                </ol>
            </nav>
            <?php    
        }
        
        function eliminaAssociazioneEtichettaDocumento($idEtichetta) {
            $query = "DELETE FROM geecD_associazioneEtichetteDocumenti WHERE idDocumento=$this->id AND idEtichetta=$idEtichetta";
            $this->db->eseguiQueryLettura($query);
        }
        
        function creaAssociazioneEtichettaDocumento($idEtichetta) {
            $query = "INSERT INTO geecD_associazioneEtichetteDocumenti VALUES($idEtichetta,$this->id)";
            $this->db->eseguiQueryLettura($query);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getCartella() {
            return $this->cartella;
        }

        public function getUtente() {
            return $this->utente;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getPercorso() {
            return $this->percorso;
        }

        public function getDataCreazione() {
            return $this->dataCreazione;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setCartella($cartella): void {
            $this->cartella = $cartella;
        }
        
        public function setUtente($utente): void {
            $this->utente = $utente;
        }
        
        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setDescrizione($descrizione): void {
            $this->descrizione = $descrizione;
        }

        public function setPercorso($percorso): void {
            $this->percorso = $percorso;
        }

        public function setDataCreazione($dataCreazione): void {
            $this->dataCreazione = $dataCreazione;
        }

    }
